﻿using AppWPClustering;
using ProjetPLIM.CoreAudio.Common;
using ProjetPLIM.Services;
using ProjetPLIM.Services.Interfaces;
using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Windows.Data.Xml.Dom;
using Windows.Devices.Sensors;
using Windows.UI.Core;
using Windows.UI.Notifications;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;

namespace ProjetPLIM_FuckItAll {
    public class ViewModel : INotifyPropertyChanged {
        #region simple bindings
        public string CurrentModeString { get; set; } = "Unknown";

        public double CurrentAccelerometerData { get; set; } = 0.0;

        public double CurrentLightData { get; set; } = 0.5;

        public double CurrentAudioData { get; set; } = 1.0;

        public event PropertyChangedEventHandler PropertyChanged;
        protected async virtual void OnPropertyChanged(string propertyName, CoreDispatcher dispatcher) {
            if (PropertyChanged != null) {
                await dispatcher.RunAsync(CoreDispatcherPriority.Normal, () =>
                {
                    this.PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
                });
            }
        }

        public double TimeBeforeReadingData { get; set; } = 1.0;
        #endregion

        #region advanced bindings
        private bool m_refreshData;
        public bool RefreshData {
            get { return m_refreshData; }
            set { m_refreshData = value; if (m_refreshData) { LaunchRefresh(); } else { CancelRefresh(); } }
        }


        public ObservableCollection<ClusterData> ClusteringData { get; set; }
        #endregion

        #region standard members
        // Cancels the refresh task
        private CancellationTokenSource m_cts;

        // Sensors
        private Accelerometer m_acc;
        private LightSensor m_ls;
        private IAudioCaptureStream m_audioCaptureStream;
        private BlockingCollection<AudioBufferCapturedEventArgs> m_recordedAudioBuffer;

        private int[] m_clustersForMode;
        #endregion

        public ViewModel() {
            m_acc = Accelerometer.GetDefault();
            m_ls = LightSensor.GetDefault();
        }

        #region methods
        public void LaunchRefresh() {
            Debug.WriteLine("Launching...");
            m_cts = new CancellationTokenSource();
            CancellationToken ct = m_cts.Token;
            CoreDispatcher dispatcher = CoreWindow.GetForCurrentThread().Dispatcher;

            var task = Task.Factory.StartNew(async () => {
                bool moreToDo = true;
                while (moreToDo) {
                    // Read from sensors
                    await ReadFromMicrophone();
                    CurrentAudioData = ComputeAverage();
                    CurrentLightData = m_ls.GetCurrentReading().IlluminanceInLux;
                    CurrentAccelerometerData = m_acc.GetCurrentReading().AccelerationZ;

                    // Notify UI
                    OnPropertyChanged("CurrentAudioData", dispatcher);
                    OnPropertyChanged("CurrentLightData", dispatcher);
                    OnPropertyChanged("CurrentAccelerometerData", dispatcher);

                    // Cancelling
                    if (ct.IsCancellationRequested) {
                        Debug.WriteLine("Cancelled");
                        return;
                    }
                    Debug.WriteLine("Looping");
                    await Task.Delay(10000);
                }
            }, m_cts.Token);
        }

        public void CancelRefresh() {
            Debug.WriteLine("Cancelling...");
            m_cts.Cancel();
        }
        #endregion

        public void SetSilent(object sender, RoutedEventArgs e) {
            CoreDispatcher dispatcher = CoreWindow.GetForCurrentThread().Dispatcher;
            Task removewarning = DoReading((Button)sender, 0, dispatcher);
        }

        public void SetLoud(object sender, RoutedEventArgs e) {
            CoreDispatcher dispatcher = CoreWindow.GetForCurrentThread().Dispatcher;
            Task removewarning = DoReading((Button)sender, 1, dispatcher);
        }

        public async Task DoReading(Button sender, int mode, CoreDispatcher dispatcher) {
            sender.IsEnabled = false;

            // Slider
            await Task.Delay((int)TimeBeforeReadingData * 1000);

            await ReadFromMicrophone();
            double audio = ComputeAverage();
            double light = m_ls.GetCurrentReading().IlluminanceInLux;
            double accelero = m_acc.GetCurrentReading().AccelerationZ;

            KMeansHandler.AddData(accelero, audio, light);

            // Init the mode <=> cluster mapping
            if (KMeansHandler.GetReadingCount() >= 2) {
                if (m_clustersForMode == null) {
                    m_clustersForMode = new int[2];
                    // Not sure how good this is, somehow I have the feeling cluster IDs can and *will* change
                    m_clustersForMode[mode] = KMeansHandler.GetLastReading();
                    m_clustersForMode[1 - mode] = 1 - KMeansHandler.GetLastReading();
                }

                ClusteringData = KMeansHandler.GetReadings();
                OnPropertyChanged("ClusteringData", dispatcher);
            }

            sender.IsEnabled = true;
        }

        public async Task RunBGTask() {
            await ReadFromMicrophone();
            double audio = ComputeAverage();
            double light = m_ls.GetCurrentReading().IlluminanceInLux;
            double accelero = m_acc.GetCurrentReading().AccelerationZ;

            KMeansHandler.AddData(audio, light, accelero);
            int mode = KMeansHandler.GetLastReading();

            ClusteringData = KMeansHandler.GetReadings();
            OnPropertyChanged("ClusteringData", CoreWindow.GetForCurrentThread().Dispatcher);

            string[] strs = new string[] { "silent", "loud" };
            ShowModeToast(strs[mode]);

            CurrentModeString = strs[mode];
        }
        private void ShowModeToast(String mode) {
            ToastTemplateType toastType = ToastTemplateType.ToastText02;

            XmlDocument toastXml = ToastNotificationManager.GetTemplateContent(toastType);

            XmlNodeList toastTextElement = toastXml.GetElementsByTagName("text");
            toastTextElement[0].AppendChild(toastXml.CreateTextNode("Changing audio mode to " + mode));
            toastTextElement[1].AppendChild(toastXml.CreateTextNode("Well, if Microsoft had actually implemented this lol"));

            IXmlNode toastNode = toastXml.SelectSingleNode("/toast");
            ((XmlElement)toastNode).SetAttribute("duration", "long");

            ToastNotification toast = new ToastNotification(toastXml);
            ToastNotificationManager.CreateToastNotifier().Show(toast);
        }

        public void LoadDemoData() {
            CoreDispatcher dispatcher = CoreWindow.GetForCurrentThread().Dispatcher;
            var task = Task.Factory.StartNew(() => {
                double acc = -0.9, l = 1, snd = 10;
                Random r = new Random();
                // first set
                for(int i = 0; i < 30; i++) {
                    KMeansHandler.AddData(acc - r.NextDouble() * 0.1, snd + r.NextDouble() * 3, l + r.NextDouble());
                }
                // different sound reading
                snd = 15;
                for (int i = 0; i < 5; i++) {
                    KMeansHandler.AddData(acc - r.NextDouble() * 0.1, snd + r.NextDouble() * 3, l + r.NextDouble());
                }
                // different acc reading
                snd = 10; acc = 0.9;
                for (int i = 0; i < 5; i++) {
                    KMeansHandler.AddData(acc + r.NextDouble() * 0.1, snd + r.NextDouble() * 5, l + r.NextDouble());
                }
                // "in the middle" data
                acc = 0; l = 5; snd = 30;
                for (int i = 0; i < 16; i++) {
                    KMeansHandler.AddData(acc + r.NextDouble() * 0.1, snd + r.NextDouble() * 3, l + r.NextDouble());
                }
                // other side of the spectrum
                acc = 0.9; l = 10; snd = 60;
                for (int i = 0; i < 50; i++) {
                    KMeansHandler.AddData(acc + r.NextDouble() * 0.1, snd + r.NextDouble() * 3, l + r.NextDouble());
                }

                m_clustersForMode = new int[2];
                m_clustersForMode[0] = 0;
                m_clustersForMode[1] = 1;

                ClusteringData = KMeansHandler.GetReadings();
                OnPropertyChanged("ClusteringData", dispatcher);
            });
        }

        #region mic helpers
        private async Task ReadFromMicrophone() {
            StartRecording();

            // Equivalent of a Thread.sleep, to wait for enough things to be recorded
            await Task.Delay(5000);

            StopRecording();
        }
        private void StartRecording() {
            // Init WASAPI interface
            m_audioCaptureStream = new AudioCaptureStream(OnAudioStreamActivated, OnAudioBufferCaptured);
            m_recordedAudioBuffer = new BlockingCollection<AudioBufferCapturedEventArgs>(new ConcurrentQueue<AudioBufferCapturedEventArgs>());
            m_audioCaptureStream.Start();
        }

        private void StopRecording() {
            m_audioCaptureStream.Stop();
        }

        private double ComputeAverage() {
            long l = 0, l2 = 0, l3;
            foreach (var w in m_recordedAudioBuffer) {
                if (w.BytesRecorded == 0) continue;
                l3 = 0;
                foreach (var w2 in w.Buffer) {
                    l3 += w2;
                }
                l += l3 / w.BytesRecorded;
                l2++;
            }
            l /= l2;
            return l;
        }

        #region WASAPI interface related handlers
        private void OnAudioBufferCaptured(AudioBufferCapturedEventArgs e) {
            m_recordedAudioBuffer.Add(e);
        }

        private void OnAudioStreamActivated(WaveFormat obj) {
        }
        #endregion

        #endregion
    }
}
